/**
* \file: configuration_defaults.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_CONFIGURATION_DEFAULTS_H
#define AAM_CONTROL_CONFIGURATION_DEFAULTS_H

#include "utils/logger.h"

/**
 * default mount options used by the automounter while automatically mounting partitions
 */
#define DEFAULT_AUTOMOUNT_OPTIONS "ro"

/**
 * the mount point directory
 */
#define DEFAULT_MEDIA_DIR "/media"

/**
 * the default access mode used to create a mount point
 */
#define DEFAULT_MOUNT_POINT_MODE 0700

/**
 * A mount point is created by automounter internally using a kind of heuristic. If the generated name already
 * exists in the mount point directory, a new one is generated by extending the old one with underscores. This
 * values defines the number of underscores, a mount point is maximally extended with until the automounter gives
 * up and the mounting fails.
 */
#define DEFAULT_MP_EXT_GIVEUP_CNT 10

/**
 * the default configuration file
 */
#define DEFAULT_CONF_FILE "/etc/automounter.conf"

/**
 * the default log level
 */
#define DEFAULT_LOG_LEVEL LOGGER_LEVEL_INFO

/**
 * defines whether or not console logging output is enabled by default
 */
#define DEFAULT_CONSOLE_ENABLED true

/**
 * defines whether or not the automounter shall daemonize by default during startup
 */
#define DEFAULT_SHALL_DAEMONIZE false

/**
 * defines whether or not the automounter shall mount the data part of mixed mode CDs
 */
#define DEFAULT_MOUNT_MIXED_MODE_CDS true

#endif
